/*
 * VRT RULES
 * 
 * Copyright (C) 2005 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

!!! XXX   DOES NOT USE BUILT-IN FUNCTIONS XXX !!!

   Additional functionality written by Patrick Mullen <pmullen@sourcefire.com>

alert tcp $EXTERNAL_NET any -> $HOME_NET 389 (msg:"EXPLOIT Microsoft Active Directory LDAP cookie denial of service attempt"; flow:to_server,established; content:"|30|"; depth:1; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-035; reference:cve,2008-1445;  classtype:attempted-dos; sid:13835; rev:1;)

 */

#include <string.h>

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_WRAP(code) code
#else
#define DEBUG_WRAP(code)
#endif


/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule13835flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule13835option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13835flow0
    }
};

// content:"0", depth 1; 
static ContentInfo rule13835content1 = 
{
    (uint8_t *)"0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13835option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13835content1
    }
};

/* references for sid 13835 */
/* reference: cve "2008-1445"; */
static RuleReference rule13835ref1 = 
{
    "cve", /* type */
    "2008-1445" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-035"; */
static RuleReference rule13835ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-035" /* value */
};

static RuleReference *rule13835refs[] =
{
    &rule13835ref1,
    &rule13835ref2,
    NULL
};
RuleOption *rule13835options[] =
{
    &rule13835option0,
    &rule13835option1,
    NULL
};

/* declare detection functions */
int rule13835eval(void *p);

static RuleMetaData rule13835service1 =
{
    "service ldap"
};

static RuleMetaData rule13835policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule13835metadata[] =
{
    &rule13835service1,
    &rule13835policy1,
    NULL
};

Rule rule13835 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "389", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13835, /* sigid */
       11, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Active Directory LDAP cookie denial of service attempt",     /* message */
       rule13835refs /* ptr to references */
        ,rule13835metadata
   },
   rule13835options, /* ptr to rule options */
   &rule13835eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* taken from snort_stream5_session.c */
#define rot(x,k) (((x)<<(k)) | ((x)>>(32-(k))))

#define mix(a,b,c)  {  a -= c;  a ^= rot(c, 4);  c += b;  b -= a;  b ^= rot(a, 6);  a += c;  c -= b;  c ^= rot(b, 8);  b += a; a -= c;  a ^= rot(c,16);  c += b;  b -= a;  b ^= rot(a,19);  a += c;  c -= b;  c ^= rot(b, 4);  b += a;  }
#define final(a,b,c)  {  c ^= b; c -= rot(b,14);  a ^= c; a -= rot(c,11);  b ^= a; b -= rot(a,25);  c ^= b; c -= rot(b,16);  a ^= c; a -= rot(c,4);   b ^= a; b -= rot(a,14);  c ^= b; c -= rot(b,24);  }

uint32_t checksum(const uint8_t *buf, uint32_t len) {
    uint32_t a = 0, b = 0, c = 0, tmp = 0;
    unsigned int i,j,k,l;

    for (i=0,j=0;i<len;i+=4) {
        tmp = 0;
        k = len - i;
        if (k > 4)
            k=4;

        for (l=0;l<k;l++) {
            tmp |= *(buf + i + l) << l*8;
        }

        switch (j) {
            case 0:
                a += tmp;
                break;
            case 1:
                b += tmp;
                break;
            case 2:
                c += tmp;
                break;
        }
        j++;

        if (j == 3) {
            mix(a,b,c);
            j = 0;
        }
    }

    final(a,b,c);

    return c;
}

typedef struct _LdapCookieHash {
    uint32_t chksum;
    uint8_t count;
} LdapCookieHash;


/* detection functions */
int rule13835eval(void *p) {
   int retval;
   uint32_t size_len, size;

   const uint8_t *cursor_normal;

   SFSnortPacket *sp = (SFSnortPacket *) p;

   BER_ELEMENT element;

   uint32_t chksum;
   LdapCookieHash *hash;

//   DEBUG_WRAP(int i);  // For debug dump of cookie data

   DEBUG_WRAP(char name[] = "ad_ldap_cookie");
   DEBUG_WRAP(printf("%s: Entering\n", name));

   if((sp == NULL) || (sp->stream_session_ptr == NULL))
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_server;
   if (checkFlow(p, rule13835options[0]->option_u.flowFlags) <= 0 ) 
      return RULE_NOMATCH;

   // content:"0", depth 1;
   if (contentMatch(p, rule13835options[1]->option_u.content, &cursor_normal) <= 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found universal sequence\n"));

   // custom detection
   // Content match puts us at the first byte of the LDAP structure size
   retval = ber_get_size(sp, cursor_normal, &size_len, &size); // message length
   if(retval < 0)
      return(RULE_NOMATCH);
   cursor_normal += size_len;

   // Message ID
   retval = ber_skip_element(sp, &cursor_normal, 0x02);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found message ID\n"));

   // Search Request (skip)
   retval = ber_skip_element(sp, &cursor_normal, 0x63);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found search request\n"));

   // Now we're at the control information.  Get down to the cookie,
   // hash it, and compare to the list.

   // Search control information
   retval = ber_point_to_data(sp, &cursor_normal, 0xa0);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found search control info\n"));

   // Univ Sequence
   retval = ber_point_to_data(sp, &cursor_normal, 0x30);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found univ seq\n"));

   // Control type
   retval = ber_skip_element(sp, &cursor_normal, 0x04);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found control type\n"));

   // Criticality
   retval = ber_skip_element(sp, &cursor_normal, 0x01);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found criticality\n"));

   // search control value
   retval = ber_point_to_data(sp, &cursor_normal, 0x04);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found search control value\n"));

   // Search Control Value (Univ Seq)
   retval = ber_point_to_data(sp, &cursor_normal, 0x30);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found search control value univ seq\n"));

   // Size
   retval = ber_skip_element(sp, &cursor_normal, 0x02);
   if(retval < 0)
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found size\n"));

   // Now we should be pointing to the cookie
   retval = ber_get_element(sp, cursor_normal, &element);
   if((retval < 0) || (element.type != 0x04) || 
                        (retval != element.data_len))
      return RULE_NOMATCH;

   DEBUG_WRAP(printf("found cookie, len=%d\n", element.data_len));
//   DEBUG_WRAP to dump hex of cookie
//   for(i=0; i<element.data_len; i++) {
//      printf("%02x ", *(element.data.data_ptr+i));
//   }
//   printf("\n");

   // Compute checksum of cookie
   // We use this value to determine a cookie is a duplicate
    hash = (LdapCookieHash *)getRuleData(sp, (uint32_t)rule13835.info.sigID);

    if(!hash) {
        hash = (LdapCookieHash *)allocRuleData(sizeof(LdapCookieHash));
        if (hash == NULL)
           return RULE_NOMATCH;

        if(storeRuleData(sp, hash, rule13835.info.sigID, &freeRuleData) < 0)
        {
           freeRuleData(hash);
           return RULE_NOMATCH;
        }

        hash->count = 0;
    }

   chksum = checksum(element.data.data_ptr, element.data_len);

   DEBUG_WRAP(printf("old checksum = 0x%08x, new checksum = 0x%08x\n", hash->chksum, chksum));

   if(hash->chksum == chksum) {
      if(hash->count == 2) {  
         hash->count++;
         return RULE_MATCH;
      } else {
         //DEBUG_WRAP(hash->count = 50); // To turn off thresholding
         hash->count++;
         if(hash->count > 50) {
            /*
             * ghetto thresholding, as thresholding isn't available
             * to SO rules
            */
            hash->count = 1;
            return RULE_MATCH;
         } 
      }
   } else {
      hash->chksum = chksum;
      hash->count = 1;
      return RULE_NOMATCH;
   }

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13835,
    NULL
};
*/
